/*
 *    MCreator note: This file will be REGENERATED on each build.
 */
package net.mcreator.ruby.init;

import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredHolder;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.BlockItem;

import net.mcreator.ruby.item.*;
import net.mcreator.ruby.RubiMod;

import java.util.function.Function;

public class RubiModItems {
	public static final DeferredRegister.Items REGISTRY = DeferredRegister.createItems(RubiMod.MODID);
	public static final DeferredItem<Item> RUBY_ORE;
	public static final DeferredItem<Item> RUBY;
	public static final DeferredItem<Item> RUBYPICKAXE;
	public static final DeferredItem<Item> RUBY_AXE;
	public static final DeferredItem<Item> RUBY_SWORD;
	public static final DeferredItem<Item> RUBY_HOE;
	public static final DeferredItem<Item> RUBY_SHOVEL;
	public static final DeferredItem<Item> SCALFATER;
	public static final DeferredItem<Item> SCALFATER_ORE;
	public static final DeferredItem<Item> SCALFATER_PICKAXE;
	public static final DeferredItem<Item> SCALFATER_AXE;
	public static final DeferredItem<Item> SCALFATER_HOE;
	public static final DeferredItem<Item> SCALFATER_SWORD;
	public static final DeferredItem<Item> SCALFATER_SHOVEL;
	public static final DeferredItem<Item> PALADIUM_SWORD;
	public static final DeferredItem<Item> PALADIUM;
	public static final DeferredItem<Item> PALADIUM_AXE;
	public static final DeferredItem<Item> PALADIUM_PICKAXE;
	public static final DeferredItem<Item> PALADIUM_HOE;
	public static final DeferredItem<Item> PALADIUM_SHOVEL;
	public static final DeferredItem<Item> PALADIUM_ORE;
	static {
		RUBY_ORE = block(RubiModBlocks.RUBY_ORE, new Item.Properties().rarity(Rarity.RARE));
		RUBY = register("ruby", RubyItem::new);
		RUBYPICKAXE = register("rubypickaxe", RubypickaxeItem::new);
		RUBY_AXE = register("ruby_axe", RubyAxeItem::new);
		RUBY_SWORD = register("ruby_sword", RubySwordItem::new);
		RUBY_HOE = register("ruby_hoe", RubyHoeItem::new);
		RUBY_SHOVEL = register("ruby_shovel", RubyShovelItem::new);
		SCALFATER = register("scalfater", ScalfaterItem::new);
		SCALFATER_ORE = block(RubiModBlocks.SCALFATER_ORE);
		SCALFATER_PICKAXE = register("scalfater_pickaxe", ScalfaterPickaxeItem::new);
		SCALFATER_AXE = register("scalfater_axe", ScalfaterAxeItem::new);
		SCALFATER_HOE = register("scalfater_hoe", ScalfaterHoeItem::new);
		SCALFATER_SWORD = register("scalfater_sword", ScalfaterSwordItem::new);
		SCALFATER_SHOVEL = register("scalfater_shovel", ScalfaterShovelItem::new);
		PALADIUM_SWORD = register("paladium_sword", PaladiumSwordItem::new);
		PALADIUM = register("paladium", PaladiumItem::new);
		PALADIUM_AXE = register("paladium_axe", PaladiumAxeItem::new);
		PALADIUM_PICKAXE = register("paladium_pickaxe", PaladiumPickaxeItem::new);
		PALADIUM_HOE = register("paladium_hoe", PaladiumHoeItem::new);
		PALADIUM_SHOVEL = register("paladium_shovel", PaladiumShovelItem::new);
		PALADIUM_ORE = block(RubiModBlocks.PALADIUM_ORE, new Item.Properties().rarity(Rarity.RARE));
	}

	// Start of user code block custom items
	// End of user code block custom items
	private static <I extends Item> DeferredItem<I> register(String name, Function<Item.Properties, ? extends I> supplier) {
		return REGISTRY.registerItem(name, supplier, new Item.Properties());
	}

	private static DeferredItem<Item> block(DeferredHolder<Block, Block> block) {
		return block(block, new Item.Properties());
	}

	private static DeferredItem<Item> block(DeferredHolder<Block, Block> block, Item.Properties properties) {
		return REGISTRY.registerItem(block.getId().getPath(), prop -> new BlockItem(block.get(), prop), properties);
	}
}